/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.hi.phonemiser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Scanner;

public class HindiLTS {
    private HashMap<String, String> UTF8toPhoneSymbols;
    private HashMap<String, String> UTF8toPhoneTypes;
    private ArrayList<String> listPhoneSym;
    private ArrayList<String> listPhoneTypes;
    private ArrayList<String> listConTypes;
    private ArrayList<String> utf8CharList;

    public HindiLTS(InputStream utf8toit3mapStream) throws IOException {
        this.loadPhoneSymbolsAndTypes(utf8toit3mapStream);
    }

    public String phonemise(String line) throws IOException {
        String[] words = line.split("\\s+");
        String results = "";
        for (int i = 0; i < words.length; ++i) {
            results = results + this.phonemiseWord(words[i].trim()) + " ";
        }
        return results.trim();
    }

    private String phonemiseWord(String word) throws IOException {
        this.utf8CharList = this.readUTF8String(word);
        this.listPhoneSym = new ArrayList();
        this.listPhoneTypes = new ArrayList();
        this.listConTypes = new ArrayList();
        for (String utf8Char : this.utf8CharList) {
            String phoneSymbol = this.UTF8toPhoneSymbols.get(utf8Char);
            String phoneType = this.UTF8toPhoneTypes.get(utf8Char);
            if (phoneSymbol == null) {
                phoneSymbol = this.getAsciiChar(utf8Char);
            }
            if (phoneType == null) {
                phoneType = "#";
            }
            this.listPhoneSym.add(phoneSymbol);
            this.listPhoneTypes.add(phoneType);
            if ("CON".endsWith(phoneType)) {
                this.listConTypes.add("U");
                continue;
            }
            this.listConTypes.add("#");
        }
        this.removeUnknownSymbols();
        this.schwaHandler();
        this.removeHal();
        this.syllabify();
        this.putStressMark();
        return this.getStringfromArrayList(this.listPhoneSym);
    }

    private ArrayList<String> putStressMark() {
        this.listPhoneSym.add(0, "'");
        return this.listPhoneSym;
    }

    private void syllabify() {
        for (int i = 0; i < this.listPhoneTypes.size(); ++i) {
            if (!this.isVowel(i)) continue;
            boolean isVowelLater = this.isVowelLater(i);
            boolean isNextSemiCon = this.isNextSemiConsonant(i);
            if (!isVowelLater) continue;
            if (isNextSemiCon) {
                this.listPhoneSym.add(i + 2, "-");
                this.listPhoneTypes.add(i + 2, "SYM");
                continue;
            }
            this.listPhoneSym.add(i + 1, "-");
            this.listPhoneTypes.add(i + 1, "SYM");
        }
    }

    private boolean isVowel(int pos) {
        return this.listPhoneTypes.get(pos).equals("VOW");
    }

    private boolean isVowelLater(int pos) {
        for (int i = pos + 1; i < this.listPhoneTypes.size(); ++i) {
            if (!this.listPhoneTypes.get(i).equals("VOW")) continue;
            return true;
        }
        return false;
    }

    private boolean isNextSemiConsonant(int pos) {
        if (pos + 1 >= this.listPhoneSym.size()) {
            return false;
        }
        return this.listPhoneSym.get(pos + 1).equals("n:") || this.listPhoneSym.get(pos + 1).equals("a:");
    }

    private String getStringfromArrayList(ArrayList<String> aList) {
        Iterator<String> listrun = aList.iterator();
        StringBuilder result = new StringBuilder();
        while (listrun.hasNext()) {
            result.append(" " + listrun.next());
        }
        return result.toString();
    }

    private String toHex4(int ch) {
        String hex = Integer.toHexString(ch).toUpperCase();
        switch (hex.length()) {
            case 3: {
                return "0" + hex;
            }
            case 2: {
                return "00" + hex;
            }
            case 1: {
                return "000" + hex;
            }
        }
        return hex;
    }

    private void loadPhoneSymbolsAndTypes(InputStream inStream) throws IOException {
        String line;
        BufferedReader bfr = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
        this.UTF8toPhoneSymbols = new HashMap();
        this.UTF8toPhoneTypes = new HashMap();
        while ((line = bfr.readLine()) != null) {
            String[] words = line.split("\\|");
            this.UTF8toPhoneSymbols.put(words[0], words[1]);
            this.UTF8toPhoneTypes.put(words[0], words[2]);
        }
        bfr.close();
    }

    private boolean isBelongs2KAVarga(String uniCodeHex) {
        int unicode = this.hexString2Int(uniCodeHex);
        int minFVChart = this.hexString2Int("0915");
        int maxFVChart = this.hexString2Int("0919");
        return unicode >= minFVChart && unicode <= maxFVChart;
    }

    private boolean isBelongs2CHAVarga(String uniCodeHex) {
        int unicode = this.hexString2Int(uniCodeHex);
        int minFVChart = this.hexString2Int("091A");
        int maxFVChart = this.hexString2Int("091E");
        return unicode >= minFVChart && unicode <= maxFVChart;
    }

    private boolean isBelongs2TAVarga(String uniCodeHex) {
        int unicode = this.hexString2Int(uniCodeHex);
        int minFVChart = this.hexString2Int("091F");
        int maxFVChart = this.hexString2Int("0923");
        return unicode >= minFVChart && unicode <= maxFVChart;
    }

    private boolean isBelongs2THAVarga(String uniCodeHex) {
        int unicode = this.hexString2Int(uniCodeHex);
        int minFVChart = this.hexString2Int("0924");
        int maxFVChart = this.hexString2Int("0929");
        return unicode >= minFVChart && unicode <= maxFVChart;
    }

    private boolean isBelongs2PAVarga(String uniCodeHex) {
        int unicode = this.hexString2Int(uniCodeHex);
        int minFVChart = this.hexString2Int("092A");
        int maxFVChart = this.hexString2Int("092E");
        return unicode >= minFVChart && unicode <= maxFVChart;
    }

    private boolean isBelongs2YAVarga(String uniCodeHex) {
        int unicode = this.hexString2Int(uniCodeHex);
        int minFVChart = this.hexString2Int("092F");
        int maxFVChart = this.hexString2Int("0939");
        return unicode >= minFVChart && unicode <= maxFVChart;
    }

    public ArrayList<String> readUTF8String(String word) throws IOException {
        CharBuffer cbuf = CharBuffer.wrap(word);
        ArrayList<String> utf8CharList = new ArrayList<String>();
        for (int i = 0; i < cbuf.length(); ++i) {
            char ch = cbuf.get(i);
            utf8CharList.add(this.toHex4(ch));
        }
        return utf8CharList;
    }

    public ArrayList<String> readUTF8File(String filename) throws IOException {
        int ch;
        ArrayList<String> utf8CharList = new ArrayList<String>();
        InputStreamReader ins = new InputStreamReader((InputStream)new FileInputStream(filename), "UTF8");
        while ((ch = ins.read()) >= 0) {
            utf8CharList.add(this.toHex4(ch));
        }
        return utf8CharList;
    }

    private void printData(String filename) throws IOException {
        ArrayList<String> utf8CharList = this.readUTF8File(filename);
        for (String utf8Char : utf8CharList) {
            String phoneSymbol = this.UTF8toPhoneSymbols.get(utf8Char);
            String phoneType = this.UTF8toPhoneTypes.get(utf8Char);
            if (phoneSymbol == null) {
                phoneSymbol = "SPACE";
            }
            if (phoneType == null) {
                phoneType = "#";
            }
            System.out.println(utf8Char + " " + phoneSymbol + " " + phoneType);
        }
    }

    public void makeProperIt3(String filename) throws IOException {
        Scanner sc = new Scanner(new File(filename));
        while (sc.hasNextLine()) {
            String line = sc.nextLine().trim();
            String[] words = line.split("\\s+");
            for (int i = 0; i < words.length; ++i) {
                System.out.println(words[i] + " --> " + this.phonemise(words[i].trim()));
            }
        }
    }

    private ArrayList<String> removeHal(ArrayList<String> lPhoneSym, ArrayList<String> lPhoneTypes) {
        for (int i = 0; i < lPhoneTypes.size(); ++i) {
            if (!lPhoneTypes.get(i).equals("HLT")) continue;
            lPhoneTypes.remove(i);
            lPhoneSym.remove(i);
            --i;
        }
        return lPhoneSym;
    }

    private void removeHal() {
        for (int i = 0; i < this.listPhoneTypes.size(); ++i) {
            if (!this.listPhoneTypes.get(i).equals("HLT")) continue;
            this.listPhoneTypes.remove(i);
            this.listPhoneSym.remove(i);
            --i;
        }
    }

    private void removeUnknownSymbols() {
        for (int i = 0; i < this.listPhoneTypes.size(); ++i) {
            if (!this.listPhoneTypes.get(i).equals("#")) continue;
            this.listPhoneTypes.remove(i);
            this.listPhoneSym.remove(i);
            --i;
        }
    }

    private String getAsciiChar(String utf8Char) {
        int intValue = Integer.parseInt(utf8Char, 16);
        char dec = (char)intValue;
        return Character.toString(dec);
    }

    private void RuleSetZero() {
        boolean isFinalCharacter = false;
        for (int i = 0; i < this.listPhoneTypes.size(); ++i) {
            String nextUchar;
            String nextPhone;
            String nextType;
            String prevType = this.listPhoneTypes.get(i);
            String prevPhone = this.listPhoneSym.get(i);
            String prevUchar = this.utf8CharList.get(i);
            if (i + 1 < this.listPhoneTypes.size()) {
                nextType = this.listPhoneTypes.get(i + 1);
                nextPhone = this.listPhoneSym.get(i + 1);
                nextUchar = this.utf8CharList.get(i + 1);
            } else {
                nextType = this.listPhoneTypes.get(i);
                nextPhone = this.listPhoneSym.get(i);
                nextUchar = this.utf8CharList.get(i);
                isFinalCharacter = true;
            }
            if (prevUchar.equals("0902")) {
                if (isFinalCharacter) {
                    this.listPhoneTypes.set(i, "CON");
                    this.listPhoneSym.set(i, "ng~");
                    this.utf8CharList.set(i, "0919");
                    this.listConTypes.set(i, "U");
                } else if (this.isBelongs2TAVarga(nextUchar)) {
                    this.listPhoneTypes.set(i, "CON");
                    this.listPhoneSym.set(i, "n");
                    this.utf8CharList.set(i, "0928");
                    this.listConTypes.set(i, "U");
                } else if (this.isBelongs2PAVarga(nextUchar)) {
                    this.listPhoneTypes.set(i, "CON");
                    this.listPhoneSym.set(i, "m");
                    this.utf8CharList.set(i, "092E");
                    this.listConTypes.set(i, "U");
                } else if (this.isBelongs2KAVarga(nextUchar)) {
                    this.listPhoneTypes.set(i, "CON");
                    this.listPhoneSym.set(i, "ng~");
                    this.utf8CharList.set(i, "0919");
                    this.listConTypes.set(i, "U");
                }
            }
            if (prevType.equals("CON") && nextType.equals("VOW")) {
                this.listConTypes.set(i, "F");
                continue;
            }
            if (!prevType.equals("VOW")) continue;
            this.listConTypes.set(i, "F");
        }
    }

    private void schwaHandler() {
        this.RuleSetZero();
        this.RuleSetOne();
        this.RuleSetTwo();
        this.RuleSetThree();
        this.RuleSetFour();
        this.RuleSetFive();
        this.RuleSetSix();
        this.RuleSetSeven();
        this.RuleSetEight();
        this.FinalizeRules();
    }

    private void FinalizeRules() {
        boolean isFinalCharacter = false;
        boolean encounterF = false;
        for (int i = 0; i < this.listPhoneTypes.size(); ++i) {
            String nextCon;
            String nextUchar;
            String nextPhone;
            String nextType;
            String prevType = this.listPhoneTypes.get(i);
            String prevPhone = this.listPhoneSym.get(i);
            String prevUchar = this.utf8CharList.get(i);
            String prevCon = this.listConTypes.get(i);
            if (i + 1 < this.listPhoneTypes.size()) {
                nextType = this.listPhoneTypes.get(i + 1);
                nextPhone = this.listPhoneSym.get(i + 1);
                nextUchar = this.utf8CharList.get(i + 1);
                nextCon = this.listConTypes.get(i + 1);
            } else {
                nextType = this.listPhoneTypes.get(i);
                nextPhone = this.listPhoneSym.get(i);
                nextUchar = this.utf8CharList.get(i);
                nextCon = this.listConTypes.get(i);
                isFinalCharacter = true;
            }
            if (isFinalCharacter) break;
            if (!"F".equals(prevCon) || !"CON".equals(prevType) || "VOW".equals(nextType) && !this.isFullVowel(nextUchar)) continue;
            this.listPhoneTypes.add(i + 1, "VOW");
            this.listPhoneSym.add(i + 1, "a");
            this.utf8CharList.add(i + 1, "093D");
            this.listConTypes.add(i + 1, "#");
        }
    }

    private void RuleSetTwo() {
        boolean isFinalCharacter = false;
        for (int i = 0; i < this.listPhoneTypes.size(); ++i) {
            String nextCon;
            String nextUchar;
            String nextPhone;
            String nextType;
            String prevType = this.listPhoneTypes.get(i);
            String prevPhone = this.listPhoneSym.get(i);
            String prevUchar = this.utf8CharList.get(i);
            String prevCon = this.listConTypes.get(i);
            if (i + 1 < this.listPhoneTypes.size()) {
                nextType = this.listPhoneTypes.get(i + 1);
                nextPhone = this.listPhoneSym.get(i + 1);
                nextUchar = this.utf8CharList.get(i + 1);
                nextCon = this.listConTypes.get(i + 1);
            } else {
                nextType = this.listPhoneTypes.get(i);
                nextPhone = this.listPhoneSym.get(i);
                nextUchar = this.utf8CharList.get(i);
                nextCon = this.listConTypes.get(i);
                isFinalCharacter = true;
            }
            if (isFinalCharacter) break;
            if (!"y".equals(nextPhone)) continue;
            if ("i".equals(prevPhone) || "ii".equals(prevPhone) || "u".equals(prevPhone) || "uu".equals(prevPhone)) {
                this.listConTypes.set(i + 1, "F");
                continue;
            }
            if (!"U".equals(prevCon)) continue;
            this.listConTypes.set(i + 1, "F");
        }
    }

    private void RuleSetThree() {
        boolean isFinalCharacter = false;
        for (int i = 0; i < this.listPhoneTypes.size(); ++i) {
            String nextCon;
            String nextUchar;
            String nextPhone;
            String nextType;
            String prevType = this.listPhoneTypes.get(i);
            String prevPhone = this.listPhoneSym.get(i);
            String prevUchar = this.utf8CharList.get(i);
            String prevCon = this.listConTypes.get(i);
            if (i + 1 < this.listPhoneTypes.size()) {
                nextType = this.listPhoneTypes.get(i + 1);
                nextPhone = this.listPhoneSym.get(i + 1);
                nextUchar = this.utf8CharList.get(i + 1);
                nextCon = this.listConTypes.get(i + 1);
            } else {
                nextType = this.listPhoneTypes.get(i);
                nextPhone = this.listPhoneSym.get(i);
                nextUchar = this.utf8CharList.get(i);
                nextCon = this.listConTypes.get(i);
                isFinalCharacter = true;
            }
            if (isFinalCharacter) break;
            if (!"U".equals(nextCon) || !"y".equals(nextPhone) && !"r".equals(nextPhone) && !"l".equals(nextPhone) && !"v".equals(nextPhone)) continue;
            if ("CON".equals(prevType) && "H".equals(prevCon)) {
                this.listConTypes.set(i + 1, "F");
                continue;
            }
            if (!"HAL".equals(prevPhone)) continue;
            this.listConTypes.set(i + 1, "F");
        }
    }

    private void RuleSetOne() {
        boolean isFinalCharacter = false;
        for (int i = 0; i < this.listPhoneTypes.size(); ++i) {
            String nextCon;
            String nextUchar;
            String nextPhone;
            String nextType;
            String prevType = this.listPhoneTypes.get(i);
            String prevPhone = this.listPhoneSym.get(i);
            String prevUchar = this.utf8CharList.get(i);
            String prevCon = this.listConTypes.get(i);
            if (i + 1 < this.listPhoneTypes.size()) {
                nextType = this.listPhoneTypes.get(i + 1);
                nextPhone = this.listPhoneSym.get(i + 1);
                nextUchar = this.utf8CharList.get(i + 1);
                nextCon = this.listConTypes.get(i + 1);
            } else {
                nextType = this.listPhoneTypes.get(i);
                nextPhone = this.listPhoneSym.get(i);
                nextUchar = this.utf8CharList.get(i);
                nextCon = this.listConTypes.get(i);
                isFinalCharacter = true;
            }
            if (isFinalCharacter) break;
            if (!"U".equals(prevCon) || !prevType.equals("CON") || !nextType.equals("HLT")) continue;
            this.listConTypes.set(i, "H");
        }
    }

    private void RuleSetFour() {
        boolean isFinalCharacter = false;
        for (int i = 0; i < this.listPhoneTypes.size(); ++i) {
            String nextCon;
            String nextUchar;
            String nextPhone;
            String nextType;
            String prevType = this.listPhoneTypes.get(i);
            String prevPhone = this.listPhoneSym.get(i);
            String prevUchar = this.utf8CharList.get(i);
            String prevCon = this.listConTypes.get(i);
            if (i + 1 < this.listPhoneTypes.size()) {
                nextType = this.listPhoneTypes.get(i + 1);
                nextPhone = this.listPhoneSym.get(i + 1);
                nextUchar = this.utf8CharList.get(i + 1);
                nextCon = this.listConTypes.get(i + 1);
            } else {
                nextType = this.listPhoneTypes.get(i);
                nextPhone = this.listPhoneSym.get(i);
                nextUchar = this.utf8CharList.get(i);
                nextCon = this.listConTypes.get(i);
                isFinalCharacter = true;
            }
            if (isFinalCharacter) break;
            if (!"U".equals(prevCon) || !this.isFullVowel(nextUchar)) continue;
            this.listConTypes.set(i, "F");
        }
    }

    private void RuleSetFive() {
        boolean isFinalCharacter = false;
        boolean encounterF = false;
        for (int i = 0; i < this.listPhoneTypes.size(); ++i) {
            String nextCon;
            String nextUchar;
            String nextPhone;
            String nextType;
            String prevType = this.listPhoneTypes.get(i);
            String prevPhone = this.listPhoneSym.get(i);
            String prevUchar = this.utf8CharList.get(i);
            String prevCon = this.listConTypes.get(i);
            if (i + 1 < this.listPhoneTypes.size()) {
                nextType = this.listPhoneTypes.get(i + 1);
                nextPhone = this.listPhoneSym.get(i + 1);
                nextUchar = this.utf8CharList.get(i + 1);
                nextCon = this.listConTypes.get(i + 1);
            } else {
                nextType = this.listPhoneTypes.get(i);
                nextPhone = this.listPhoneSym.get(i);
                nextUchar = this.utf8CharList.get(i);
                nextCon = this.listConTypes.get(i);
                isFinalCharacter = true;
            }
            if (isFinalCharacter) break;
            if ("U".equals(prevCon) && !encounterF) {
                this.listConTypes.set(i, "F");
                break;
            }
            if ("F".equals(prevCon)) break;
        }
    }

    private void RuleSetSix() {
        boolean isFinalCharacter = false;
        boolean encounterF = false;
        int i = this.listPhoneTypes.size() - 1;
        if (i < 0) {
            return;
        }
        String prevType = this.listPhoneTypes.get(i);
        String prevPhone = this.listPhoneSym.get(i);
        String prevUchar = this.utf8CharList.get(i);
        String prevCon = this.listConTypes.get(i);
        if ("U".equals(prevCon) && "CON".equals(prevType)) {
            this.listConTypes.set(i, "H");
        }
    }

    private void RuleSetSeven() {
        boolean isFinalCharacter = false;
        boolean encounterF = false;
        for (int i = 0; i < this.listPhoneTypes.size(); ++i) {
            String nextCon;
            String nextUchar;
            String nextPhone;
            String nextType;
            String prevType = this.listPhoneTypes.get(i);
            String prevPhone = this.listPhoneSym.get(i);
            String prevUchar = this.utf8CharList.get(i);
            String prevCon = this.listConTypes.get(i);
            if (i + 1 < this.listPhoneTypes.size()) {
                nextType = this.listPhoneTypes.get(i + 1);
                nextPhone = this.listPhoneSym.get(i + 1);
                nextUchar = this.utf8CharList.get(i + 1);
                nextCon = this.listConTypes.get(i + 1);
            } else {
                nextType = this.listPhoneTypes.get(i);
                nextPhone = this.listPhoneSym.get(i);
                nextUchar = this.utf8CharList.get(i);
                nextCon = this.listConTypes.get(i);
                isFinalCharacter = true;
            }
            if (isFinalCharacter) break;
            if (!"U".equals(prevCon) || !"CON".equals(prevType)) continue;
            if ("CON".equals(nextType) && "H".equals(nextCon)) {
                this.listConTypes.set(i, "F");
                continue;
            }
            if (!"SYM".equals(nextType) || !"#".equals(nextCon)) continue;
            this.listConTypes.set(i, "F");
        }
    }

    private void RuleSetEight() {
        boolean isFinalCharacter = false;
        boolean encounterF = false;
        for (int i = 1; i < this.listPhoneTypes.size() - 1; ++i) {
            String prevType = this.listPhoneTypes.get(i - 1);
            String prevPhone = this.listPhoneSym.get(i - 1);
            String prevUchar = this.utf8CharList.get(i - 1);
            String prevCon = this.listConTypes.get(i - 1);
            String currentType = this.listPhoneTypes.get(i);
            String currentPhone = this.listPhoneSym.get(i);
            String currentUchar = this.utf8CharList.get(i);
            String currentCon = this.listConTypes.get(i);
            String nextType = this.listPhoneTypes.get(i + 1);
            String nextPhone = this.listPhoneSym.get(i + 1);
            String nextUchar = this.utf8CharList.get(i + 1);
            String nextCon = this.listConTypes.get(i + 1);
            if (isFinalCharacter) break;
            if (!"U".equals(currentCon)) continue;
            if ("F".equals(prevCon) && "F".equals(nextCon)) {
                this.listConTypes.set(i, "H");
                continue;
            }
            this.listConTypes.set(i, "F");
        }
    }

    private void printArrayList(ArrayList<String> aList) {
        Iterator<String> listrun = aList.iterator();
        System.out.println();
        while (listrun.hasNext()) {
            System.out.print(" " + listrun.next());
        }
        System.out.println();
    }

    private boolean isFullVowel(String uniCodeHex) {
        int unicode = this.hexString2Int(uniCodeHex);
        int minFVChart = this.hexString2Int("0904");
        int maxFVChart = this.hexString2Int("0914");
        return unicode >= minFVChart && unicode <= maxFVChart;
    }

    private String int2HexString(int ch) {
        String hex = Integer.toHexString(ch).toUpperCase();
        switch (hex.length()) {
            case 3: {
                return "0" + hex;
            }
            case 2: {
                return "00" + hex;
            }
            case 1: {
                return "000" + hex;
            }
        }
        return hex;
    }

    private int hexString2Int(String hexCode) {
        return Integer.parseInt(hexCode, 16);
    }

    private void printSchwaSequence() {
        if (this.listPhoneSym.size() != this.listConTypes.size() || this.listPhoneSym.size() != this.utf8CharList.size() || this.listPhoneSym.size() != this.listPhoneTypes.size()) {
            System.err.println(this.utf8CharList.size() + " " + this.listPhoneSym.size() + " " + this.listPhoneTypes.size() + " " + this.listConTypes.size());
            throw new RuntimeException("Array list sizes doesnot match !!!");
        }
        System.out.println("***************");
        for (int i = 0; i < this.utf8CharList.size(); ++i) {
            System.out.println(this.utf8CharList.get(i) + " " + this.listPhoneSym.get(i) + " " + this.listPhoneTypes.get(i) + " " + this.listConTypes.get(i));
        }
    }

    public static void main(String[] args) throws IOException {
        HindiLTS utf8r = new HindiLTS(new FileInputStream("/Users/sathish/Work/BitBucket/marytts/marytts-lang-hi/src/main/resources/marytts/language/hi/lexicon/UTF8toIT3.hi.list"));
        System.out.println("Result : " + utf8r.phonemise("\u0906\u092a\u0915\u093e"));
        System.out.println("Result : " + utf8r.phonemise("\u092c\u091a\u092a\u0928"));
        System.out.println("Result : " + utf8r.phonemise("\u092a\u094d\u0930\u093f\u092f\u0924\u092e"));
        System.out.println("Result : " + utf8r.phonemise("\u0906\u092e\u0902\u0924\u094d\u0930\u0923"));
        System.out.println("Result : " + utf8r.phonemise("\u0915\u0924\u0908"));
        System.out.println("Result : " + utf8r.phonemise("\u0939\u0942\u0901"));
        utf8r.makeProperIt3("/Users/sathish/Work/BitBucket/delme/text/hin_0004.txt");
    }
}

